//  Copyright (C) 2005-2006 Lev Kazarkin. All Rights Reserved.
//
//  TightVNC is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
//  USA.
//
// TightVNC distribution homepage on the Web: http://www.tightvnc.com/

#ifndef _WINVNC_VIDEODRIVER
#define _WINVNC_VIDEODRIVER

#include "stdhdrs.h"
#include "vncRegion.h"


//
// From ZoneOS ZoneScreen XPDM Virtual Display Driver
//

// Current version of updates source engine.
#define ZS_CURRENT_UPDATES_ENGINE_VERSION 1

// Lenght of ring buffer with list of rectangles to be updated.
#define ZS_UPDATES_BUFFER_LENGTH 16384

typedef enum _ZS_UPDATE_TYPE {

    //
    // Move rectangle from source point ('Point' field) to target rectangle
    // ('Rectangle' field).
    //
    ZsUpdateMove = 0,

    //
    // All other operations. Frame changes are bound by corresponding
    // update rectangle - 'Rectangle' field of update record.
    //
    ZsUpdateOther

} ZS_UPDATE_TYPE, *PZS_UPDATE_TYPE;

// Structure describing single change in corresponding frame.
typedef struct _ZS_UPDATE_RECORD {

    // Update type, describing meaning of other structure fields.
    ZS_UPDATE_TYPE Type;

    // Generally for x86-x64 interoperability.
    ULONG Reserved;

    // Rectangle containing all changes occured.
    RECT Rectangle;

    //
    // Optional update parameter meaning corresponding point object.
    // For move copy operation this is
    // source point to copy bitmap from.
    //
    POINT Point;

} ZS_UPDATE_RECORD, *PZS_UPDATE_RECORD;

//
// Structure mapped into calling process to allow monitoring of
// changes occured in frame by polling single field
// 'CurrentPosition' instead of polling whole frame buffer.
//
typedef struct _ZS_UPDATES_BUFFER {

    //
    // Ring buffer with descriptions of changes occured in underlying frame.
    // 'CurrentPosition' field means index for update item
    // to be set by next frame update.
    //
    ZS_UPDATE_RECORD Updates[ZS_UPDATES_BUFFER_LENGTH];

    //
    // Ring variable meaning current position in 'Updates' buffer
    // (index of last update item plus 1 modulus buffer length).
    // Calling application can determine if any changes occured
    // in target frame by comparing current value of this variable with
    // value cached from previous poll.
    //
    ULONG CurrentPosition;

} ZS_UPDATES_BUFFER, *PZS_UPDATES_BUFFER;


//
// Driver-specific escape codes.
//

//
// Query architecture version of underlying display driver.
// To check available features, compare it with
// 'ZS_CURRENT_UPDATES_ENGINE_VERSION' version.
//
#define ZS_ESC_QUERY_VERSION 0x10001

//
// Map ring buffer with changes and frame buffer to calling process.
// Unmapping is done by process itself by unmapping corresponding
// section views returned by driver as a mapping result.
//
#define ZS_ESC_MAP_BUFFERS 0x10002

typedef struct _ZS_MAP_BUFFERS_OUT {

    // Ring buffer with frame updates.
    PZS_UPDATES_BUFFER Updates;

    // Direct-access frame buffer view.
    PVOID FrameBufferView;

} ZS_MAP_BUFFERS_OUT, *PZS_MAP_BUFFERS_OUT;

//
// End of ZoneOS ZoneScreen source.
//


typedef BOOL (WINAPI* pEnumDisplayDevices)(PVOID,DWORD,PVOID,DWORD);

class vncDesktop;

class vncVideoDriver
{

// Fields
public:

// Methods
public:
	// Make the desktop thread & window proc friends

	vncVideoDriver();
	~vncVideoDriver();
	BOOL Activate(BOOL fForDirectAccess, const RECT *prcltarget);
	void Deactivate();
	BOOL CheckVersion();
	BOOL MapSharedbuffers(BOOL fForDirectScreenAccess);
	void UnMapSharedbuffers();
	void HandleDriverChanges(
		vncDesktop *pDesk,
		vncRegion &rgn,
		int xoffset,
		int yoffset,
		BOOL &bPointerShapeChange);
	void HandleDriverChangesSeries(
		vncDesktop *pDesk,
		vncRegion &rgn,
		int xoffset,
		int yoffset,
		const ZS_UPDATE_RECORD *first,
		const ZS_UPDATE_RECORD *last,
		BOOL &bPointerShapeChange);
    void ResetCounter() { oldCounter = bufdata.Updates->CurrentPosition; }

    BYTE *GetScreenView(void) {	return (BYTE*)bufdata.FrameBufferView; }

	BOOL IsActive(void) {	return m_fIsActive; }
	BOOL IsDirectAccessInEffect(void) {	return m_fDirectAccessInEffect; }
	BOOL IsHandlingScreen2ScreenBlt(void) { return m_fHandleScreen2ScreenBlt; }

    PCSTR GetDeviceName() { return m_devname; }
    RECT GetCurrentRect() { return m_rect; }
    void SetCurrentRect( RECT& rect ) { m_rect = rect; }
	
protected:

	static BOOL LookupVideoDevice(LPCTSTR szDeviceString, INT &devNum, DISPLAY_DEVICE *pDd);
    static BOOL CALLBACK monitorEnumProc(
        HMONITOR hMonitor,
        HDC hdcMonitor,
        LPRECT lprcMonitor,
        LPARAM dwData
    );

	char	m_devname[32];
    RECT    m_rect;

	ZS_MAP_BUFFERS_OUT bufdata;
	ULONG oldCounter;
	HDC m_gdc;

	bool	m_fIsActive;
	bool	m_fDirectAccessInEffect;
	bool	m_fHandleScreen2ScreenBlt;

	static char	vncVideoDriver::szDriverString[];
};


#endif // _WINVNC_VIDEODRIVER
